using System;
using System.Data;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.BOL
{
	/// <summary>
	/// Summary description for IssueReturnReport.
	/// </summary>
	public class IssueReturnReport:VbecsReport
	{
		//private bool _sortByDate;
		private int _recordCount = int.MinValue;

		#region constructors

		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5501"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Instance of IssueReturnReport</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5502"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor
		/// </summary>
		public IssueReturnReport()
		{
			SortByDate = true;
			IsScheduled = false;
		}

		#endregion


		#region properties

		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5503"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5504"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Indicates how the information on the report should be sorted
		/// </summary>
		public bool SortByDate
		{
			get
			{
				if (this.ParameterRow.IsNull(ARTIFICIAL.SortByDate))
				{
					return false;
				}

				return Convert.ToBoolean(this.ParameterRow[ARTIFICIAL.SortByDate]);
			}
			set
			{
				this.ParameterRow[ARTIFICIAL.SortByDate] = value;
			}
		}


		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5505"> 
		///		<ExpectedInput>Date range that will return data</ExpectedInput>
		///		<ExpectedOutput>A count of 1 or greater</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5506"> 
		///		<ExpectedInput>A future date range</ExpectedInput>
		///		<ExpectedOutput>A count of 0</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns the number of records on the report
		/// </summary>
		public int RecordCount
		{
			get
			{
				if (_recordCount == int.MinValue)
				{
					_recordCount = DAL.IssueReturnReport.GetIssueReturnReportCount(this.StartDate, this.EndDate, Common.LogonUser.LogonUserDivisionCode);//GetRecordCount();
				}
				return _recordCount;
			}
		}

		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5509"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Non empty string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5510"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns the search criteria for the report
		/// </summary>
		public string SearchCriteria
		{
			get
			{
				return "Issued between " + Common.VBECSDateTime.FormatDateString(StartDate) + " and " + Common.VBECSDateTime.FormatDateString(EndDate) + 
					", sorted by " + (SortByDate ? "issue date." : "patient name.");
			}
		}

		#endregion


		#region methods

		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5511"> 
		///		<ExpectedInput>A date range that will return records</ExpectedInput>
		///		<ExpectedOutput>At least one record</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5512"> 
		///		<ExpectedInput>A future date range</ExpectedInput>
		///		<ExpectedOutput>No records</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns the report in a DataSet
		/// BR_76.01, BR_76.02, BR_76.04
		/// </summary>
		public DataSet CreateReport()
		{
			DataSet dsReport = new DataSet();

			DataTable dtReport = DAL.IssueReturnReport.GetIssueReturnReport(this.StartDate, this.EndDate, Common.LogonUser.LogonUserDivisionCode);
			
			for (int i=0; i<dtReport.Rows.Count; i++)
			{
				DataRow dr = dtReport.Rows[i];
				if (!dr.IsNull(Common.DatabaseConstants.ArtificialColumnNames.PooledUnitsCount))
				{
					if (Convert.ToInt32(dr[Common.DatabaseConstants.ArtificialColumnNames.PooledUnitsCount]) > 0)
					{
						dr[TABLE.BloodProduct.ProductShortName] = dr[TABLE.BloodProduct.ProductShortName].ToString()+" ("+dr[Common.DatabaseConstants.ArtificialColumnNames.PooledUnitsCount].ToString()+")";
					}
				}
			}
			
			
			
			dsReport.Tables.Add(dtReport.Copy());

			return dsReport;
		}

		#endregion

		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/5/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6105"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6106"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Generate and print report
		/// Used by VbecsConsoleReport application
		/// </summary>
        protected override VbecsReportPrinter createReportPrinter()
		{
            DataSet reportData = this.CreateReport();
            BOL.VbecsUser user = new BOL.VbecsUser(this.PrintedBy);
            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(user.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(this.SearchCriteria);

            ReportDataSource reportSourceMain = new ReportDataSource();
            if (reportData.Tables.Count > 0)
            {
                reportSourceMain.Name = "IssuedReturnedDataSet";
                reportSourceMain.Value = reportData.Tables[0];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + "\\Reports.dll");
            Stream stream;
            if (this.SortByDate)
            {
                stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.IssueReturnUnits.IssuedReturnedDate.rdlc");
            }
            else
            {
                stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.IssueReturnUnits.IssuedReturnedPatient.rdlc");
            }

            LocalReport report = new LocalReport();
            report.DataSources.Add(reportSourceHeader);
            report.DataSources.Add(reportSourceFooter);
            report.DataSources.Add(reportSourceMain);
            report.LoadReportDefinition(stream);

            return new BOL.VbecsReportPrinter(this.PrinterName, true, report);
        }

		/// <summary>
		/// GenerateReport
		/// </summary>
		/// <param name="printedBy"></param>
		/// <returns></returns>
		private void GenerateReport(string printedBy)
		{
			/*ReportClass report = null;
			if (SortByDate)
			{
				report = new gov.va.med.vbecs.reports.IssueReturnUnits.IssueReturnDate();
			}
			else
			{
				report = new gov.va.med.vbecs.reports.IssueReturnUnits.IssueReturnPatient();
			}

			// Set data source
			report.SetDataSource(this.CreateReport());

			DataSet dsHeader =  BOL.VbecsReport.GetReportHeader(printedBy);
			report.OpenSubreport("ReportHeader.rpt").SetDataSource(dsHeader);

			DataSet dsFooter = BOL.VbecsReport.GetReportFooter(this.SearchCriteria);
			report.OpenSubreport("ReportFooter.rpt").SetDataSource(dsFooter);

			return report;*/
		}
	}
}
